@extends('layouts.auth')
@section('page-title',__('site.join-list'))
@section('content')
    @if( env('HIDE_MAILING_LIST')!='true')
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">@lang('site.join-list') <a href="{{ url('/') }}" class="float-right"><i class="fa fa-home"></i></a></div>

                    <div class="card-body">
                        @include('partials.flash_message')

                        @lang('site.join-list-text')
                        <form  method="POST" action="{{ route('site.join-list') }}" class="mt-2">
                            @csrf
                            <div class="form-group">
                                <label for="email">@lang('site.email')</label>
                                <input class="form-control" type="text" id="email" name="email" required value="{{ old('email') }}">
                            </div>
                            <div class="form-group">
                                <label>@lang('site.verification')</label><br/>
                                <label for="">{!! clean( captcha_img() ) !!}</label>
                                <input required class="form-control" type="text" name="captcha" placeholder="@lang('site.verification-hint')"/>
                            </div>
                            <button type="submit" class="btn btn-danger ">@lang('site.subscribe')</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
@endsection
