@extends('layouts.admin-page')

@section('pageTitle',__('site.newsletter'))
@section('page-title',__('site.newsletter').' #'.$newsletter->id)

@section('page-content')
    <div class="container-fluid">
        <div class="row">


            <div class="col-md-12">
                <div  >
                    <div  >
                        @can('access','view_newsletters')
                        <a href="{{ url('/admin/newsletters') }}" title="Back"><button class="btn btn-warning btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> @lang('site.back')</button></a>
                        @endcan
                        @can('access','edit_newsletter')
                        <a href="{{ url('/admin/newsletters/' . $newsletter->id . '/edit') }}" title="Edit newsletter"><button class="btn btn-primary btn-sm"><i class="fa fa-pencil-square-o" aria-hidden="true"></i> @lang('site.edit')</button></a>
                        @endcan
                        @can('access','delete_newsletter')
                        <form method="POST" action="{{ url('admin/newsletters' . '/' . $newsletter->id) }}" accept-charset="UTF-8" style="display:inline">
                            {{ method_field('DELETE') }}
                            {{ csrf_field() }}
                            <button type="submit" class="btn btn-danger btn-sm" title="@lang('site.delete') newsletter" onclick="return confirm(&quot;@lang('site.confirm-delete')?&quot;)"><i class="fa fa-trash-o" aria-hidden="true"></i> @lang('site.delete')</button>
                        </form>
                        @endcan
                        <br/>
                        <br/>

                        <div class="card">
                         <div class="card-header">
                             @lang('site.subject')
                        </div>
                        <div class="card-body">
                            {{ $newsletter->subject }}
                        </div>
                        </div>

                        <div class="card">
                         <div class="card-header">
                            @lang('site.content')
                        </div>
                        <div class="card-body">
                            {!! $newsletter->content !!}
                        </div>
                        </div>

                        <div class="card">
                         <div class="card-header">
                          @lang('site.enabled')
                        </div>
                        <div class="card-body">
                            {{ boolToString($newsletter->enabled) }}
                        </div>
                        </div>

                        <div class="card">
                         <div class="card-header">
                           @lang('site.sent')
                        </div>
                        <div class="card-body">
                            {{ boolToString($newsletter->sent) }}
                        </div>
                        </div>

                        <div class="card">
                         <div class="card-header">
                           @lang('site.send-date')
                        </div>
                        <div class="card-body">
                            {{  Illuminate\Support\Carbon::parse($newsletter->send_date)->format('d/M/Y') }}
                        </div>
                        </div>
<div class="card">
 <div class="card-header">
  @lang('site.recipients')
</div>
<div class="card-body">
    <ul  >
        @if(!empty($newsletter->mailing_list))
            <li><small>@lang('site.mailing-list')</small></li>
        @endif
        @if(!empty($newsletter->candidates))
            <li><small>@lang('site.candidates')</small></li>
        @endif
        @if(!empty($newsletter->employers))
            <li><small>@lang('site.employers')</small></li>
        @endif


    </ul>
</div>
</div>


                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
