@extends('layouts.admin-page')

@section('search-form',url('/admin/newsletters'))


@section('pageTitle',__('site.newsletters'))
@section('page-title',__('site.newsletters'))

@section('page-content')
    <div class="container-fluid">
        <div class="row">


            <div class="col-md-12">
                <div>
                    <div>
                        @can('access','create_newsletter')
                        <a href="{{ url('/admin/newsletters/create') }}" class="btn btn-success btn-sm" title="@lang('site.add-new') @lang('site.newsletter')">
                            <i class="fa fa-plus" aria-hidden="true"></i> @lang('site.add-new')
                        </a>
                        <br/>
                        <br/>
                        @endcan
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>#</th><th>@lang('site.subject')</th>
                                        <th>@lang('site.send-date')</th>
                                        <th>@lang('site.sent')</th><th>@lang('site.enabled')</th>
                                        <th>@lang('site.recipients')</th>
                                        <th>@lang('site.actions')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach($newsletters as $item)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $item->subject }}</td>
                                        <td>{{  Illuminate\Support\Carbon::parse($item->send_date)->format('d/M/Y') }}</td>
                                        <td>{{ boolToString($item->sent) }}</td><td>{{ boolToString($item->enabled) }}</td>
                                        <td>
                                            <ul class="p-0 m-0">
                                                @if(!empty($item->mailing_list))
                                                <li><small>@lang('site.mailing-list')</small></li>
                                                @endif
                                                    @if(!empty($item->candidates))
                                                        <li><small>@lang('site.candidates')</small></li>
                                                    @endif
                                                    @if(!empty($item->employers))
                                                        <li><small>@lang('site.employers')</small></li>
                                                    @endif


                                            </ul>
                                        </td>
                                        <td>
                                             <div class="dropdown d-inline mr-2">
                                                                   <button class="btn btn-sm btn-primary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                   <i class="fa fa-cogs"></i>  @lang('site.actions')
                                                                   </button>
                                                                   <div class="dropdown-menu">
                                                                     @can('access','view_newsletter')
                                                                     <a class="dropdown-item" href="{{ url('/admin/newsletters/' . $item->id) }}"><i class="fa fa-eye" aria-hidden="true"></i> @lang('site.view')</a>
                                                                     @endcan
                                                                     @can('access','edit_newsletter')
                                                                     <a class="dropdown-item" href="{{ url('/admin/newsletters/' . $item->id . '/edit') }}"><i class="fa fa-edit" aria-hidden="true"></i> @lang('site.edit')</a>
                                                                     @endcan
                                                                     @can('access','delete_newsletter')
                                                                     <a onclick="$('#delete-{{ $item->id }}').submit()" class="dropdown-item" href="#"><i class="fa fa-trash" aria-hidden="true"></i> @lang('site.delete')</a>
                                                                     @endcan
                                                                   </div>
                                                                 </div>

                                            <form onsubmit="return confirm(&quot;@lang('site.confirm-delete')&quot;)" id="delete-{{ $item->id }}" method="POST" action="{{ url('/admin/newsletters' . '/' . $item->id) }}" accept-charset="UTF-8" style="display:inline">
                                                {{ method_field('DELETE') }}
                                                {{ csrf_field() }}
                                             </form>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                            <div class="pagination-wrapper"> {!! $newsletters->appends(['search' => Request::get('search')])->render() !!} </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
