<div class="form-group {{ $errors->has('subject') ? 'has-error' : ''}}">
    <label for="subject" class="control-label">{{ __('site.subject') }}</label>
    <input required class="form-control" name="subject" type="text" id="subject" value="{{ old('subject',isset($newsletter->subject) ? $newsletter->subject : '') }}" >
    {!! $errors->first('subject', '<p class="help-block">:message</p>') !!}
</div>
<div class="form-group {{ $errors->has('content') ? 'has-error' : ''}}">
    <label for="content" class="control-label">{{ __('site.content') }}</label>
    <textarea  required class="form-control" rows="5" name="content" type="textarea" id="content" >{{ old('content',isset($newsletter->content) ? $newsletter->content : '') }}</textarea>
    {!! $errors->first('content', '<p class="help-block">:message</p>') !!}
</div>
<div class="form-group {{ $errors->has('enabled') ? 'has-error' : ''}}">
    <label for="enabled" class="control-label">{{ __('site.enabled') }}</label>
    <select required  name="enabled" class="form-control" id="enabled" >
    @foreach (json_decode('{"1":"Yes","0":"No"}', true) as $optionKey => $optionValue)
        <option value="{{ $optionKey }}" {{ ((null !== old('enabled',@$newsletter->enabled)) && old('newsletter',@$newsletter->enabled) == $optionKey) ? 'selected' : ''}}>{{ $optionValue }}</option>
    @endforeach
</select>
    {!! $errors->first('enabled', '<p class="help-block">:message</p>') !!}
</div>


<div class="form-group {{ $errors->has('send_date') ? 'has-error' : ''}}">
    <label for="send_date" class="control-label">{{ __('site.send-date') }}</label>
    <input required  class="form-control date" name="send_date" type="text" id="send_date" value="{{ old('send_date',isset($newsletter->send_date) ? $newsletter->send_date : '') }}" >
    {!! $errors->first('send_date', '<p class="help-block">:message</p>') !!}
</div>

<h3></h3>

<div class="form-group">
    <label  class="control-label" >@lang('site.send-to')</label>
    <div class="container-fluid">
        <div class="row">
            <div class="custom-control custom-checkbox mb-3 mr-5">
                <input type="hidden" name="mailing_list" value="0">
                <input {{ old('mailing_list',isset($newsletter->mailing_list) ? $newsletter->mailing_list : 0)==1 ? 'checked':'' }} class="custom-control-input" id="mailing_list" type="checkbox" name="mailing_list" value="1" >
                <label class="custom-control-label" for="mailing_list">@lang('site.mailing-list') ({{ \App\MailingList::count() }})</label>
            </div>
            <div class="custom-control custom-checkbox mb-3 mr-5">
                <input type="hidden" name="candidates" value="0">
                <input {{ old('candidates',isset($newsletter->candidates) ? $newsletter->candidates : 0)==1 ? 'checked':'' }}  class="custom-control-input" id="candidates" type="checkbox" name="candidates" value="1">
                <label class="custom-control-label" for="candidates">@lang('site.candidates') ({{ \App\Candidate::count() }})</label>
            </div>
            <div class="custom-control custom-checkbox mb-3">
                <input type="hidden" name="employers" value="0">
                <input  {{ old('employers',isset($newsletter->employers) ? $newsletter->employers : 0)==1 ? 'checked':'' }}  class="custom-control-input" id="employers" type="checkbox" name="employers" value="1">
                <label class="custom-control-label" for="employers">@lang('site.employers') ({{ \App\Employer::count() }})</label>
            </div>
        </div>
    </div>

</div>


<div class="form-group">
    <input class="btn btn-primary" type="submit" value="{{ $formMode === 'edit' ? __('site.update') : __('site.create') }}">
</div>

@section('header')
    <link rel="stylesheet" href="{{ asset('vendor/summernote/summernote-bs4.css') }}">
    <link href="{{ asset('vendor/pickadate/themes/default.date.css') }}" rel="stylesheet">
    <link href="{{ asset('vendor/pickadate/themes/default.time.css') }}" rel="stylesheet">
    <link href="{{ asset('vendor/pickadate/themes/default.css') }}" rel="stylesheet">
@endsection

@section('footer')
    <script src="{{ asset('vendor/summernote/summernote-bs4.js') }}"></script>
    <script src="{{ asset('themes/main/js/summernote/summernote-active.js') }}"></script>
    <script src="{{ asset('vendor/pickadate/picker.js') }}" type="text/javascript"></script>
    <script src="{{ asset('vendor/pickadate/picker.date.js') }}" type="text/javascript"></script>
    <script src="{{ asset('vendor/pickadate/picker.time.js') }}" type="text/javascript"></script>
    <script src="{{ asset('vendor/pickadate/legacy.js') }}" type="text/javascript"></script>
    <script>
        $('textarea#content').summernote();
        $('.date').pickadate({
            format: 'yyyy-mm-dd'
        });

    </script>
@endsection
