@extends('layouts.admin-page')

@section('search-form',url('/admin/mailing-lists'))

@section('pageTitle','Mailing list: '.\App\MailingList::count())
@section('page-title','Mailing list: '.\App\MailingList::count())

@section('page-content')
    <div class="container-fluid">
        <div class="row">


            <div class="col-md-12">
                <div >
                    <div  >
                        <a href="{{ url('/admin/mailing-lists/create') }}" class="btn btn-success btn-sm" title="@lang('site.add-new')">
                            <i class="fa fa-plus" aria-hidden="true"></i> @lang('site.add-email')
                        </a>



                        <br/>
                        <br/>
                        <form action="{{ route('admin.mailing-list.delete-multiple') }}" method="post">
                            @csrf
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" id="selectAll" class="delCheckbox"></th>
                                        <th>#</th><th>@lang('site.email')</th>
                                        <th>@lang('site.name')</th>
                                        <th>@lang('site.actions')</th>
                                    </tr>
                                </thead>

                                <tbody id="emailList">
                                @foreach($mailinglists as $item)
                                    <tr>
                                        <td><input  class="delCheckbox" type="checkbox" name="{{ $item->id }}" value="{{ $item->id }}"></td>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $item->email }}</td>
                                        <td>{{ $item->name }}</td>
                                        <td>
                                            <a href="{{ url('/admin/mailing-lists/' . $item->id) }}" title="@lang('site.view')"><button class="btn btn-info btn-sm"><i class="fa fa-eye" aria-hidden="true"></i> @lang('site.view')</button></a>
                                            <a href="{{ url('/admin/mailing-lists/' . $item->id . '/edit') }}" title="@lang('site.edit')"><button class="btn btn-primary btn-sm"><i class="fa fa-edit" aria-hidden="true"></i> @lang('site.edit')</button></a>
                                            <button type="button" class="btn btn-danger btn-sm" title="@lang('site.delete')" onclick="$('#deleteForm{{ $item->id }}').submit()"><i class="fa fa-trash" aria-hidden="true"></i> @lang('site.delete')</button>

                                        @section('footer')
                                                 @parent
                                                <form  onsubmit="return confirm(&quot;@lang('site.confirm-delete')&quot;)" id="deleteForm{{ $item->id }}" method="POST" action="{{ url('/admin/mailing-lists' . '/' . $item->id) }}" accept-charset="UTF-8" style="display:inline">
                                                    {{ method_field('DELETE') }}
                                                    {{ csrf_field() }}

                                                </form>
                                            @endsection

                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>

                            </table>
                            <div class="pagination-wrapper"> {!! $mailinglists->appends(['search' => Request::get('search')])->render() !!} </div>
                        </div>
                         <button type="submit" onclick="return confirm(&quot;@lang('site.confirm-delete')&quot;)" id="delButton" style="display: none" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i> @lang('site.delete')</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footer')
    <script>
        $("#selectAll").click(function(){
            $("#emailList input[type=checkbox]").prop('checked', $(this).prop('checked'));

        });
        $('.delCheckbox').click(function(){
            var show = false;
            $('.delCheckbox').each(function(){
                if($(this).prop('checked')){
                    show = true;
                }
            });
            if(show){
                $('#delButton').fadeIn();
            }
            else{
                $('#delButton').fadeOut();
            }
        });



    </script>
@endsection
