$(document).ready(function(){

// Base30 export
//asyncTest("Base30 import / export", function() {
//	require(['text!' + ''])
//	.then(function(expectedtext){
//		QUnit.expect(1)
//		
//		QUnit.equal(
//			true
//			, true
//		)
//		
//		QUnit.start()
//	})
//})

test("export tests - native roundtrip", function() {
//	QUnit.expect(1)
	
	var data = [{"x":[172,170,167,164,161,149,144,136,131,104,94,86,71,65,62,55,54,52,49,48,48,48,51,54,63,66,78,82,89,97,103,107,126,129,130,135,139,147,149,152,155,156,159,159,159,159,157,156,156,154,153,151,150,149,148,147,147,147,151,154,162,165,177,183,197,204,209,231,238,271,284,293,315,323,330,340,343,343,339,336,324,317,283,271,263,243,236,214,210,204,199,197,195,196,208,213,231,239,245,264,273,309,326,338,370,382,419,428,441,456,464,475,476,475,468,461,432,418,406,384,378,359,355,351,349,349,350,370,378,417,436,488,501,515,542,553,569,589,626,630,633,634,629,601,591,580,553,542,505,494,485,470,464,459,446,445,447,451,471,479,506,516,545,558,564,579,583,586,591],"y":[280,279,277,275,272,262,258,250,244,203,188,177,155,147,138,123,118,110,95,91,80,77,66,63,56,54,50,50,49,48,48,48,53,56,58,66,73,89,93,99,109,116,137,141,151,155,167,170,174,183,187,199,203,207,213,217,230,233,241,246,251,252,256,257,259,259,259,255,251,235,226,220,200,193,186,167,160,140,132,128,116,112,103,101,101,104,107,119,124,130,140,149,167,172,197,205,221,225,228,234,235,236,236,235,226,221,200,191,180,164,155,127,121,117,105,100,85,81,80,80,81,100,109,122,142,158,168,211,222,254,263,278,279,279,279,276,272,263,224,217,209,183,165,126,117,109,93,87,79,79,79,83,88,93,119,134,172,183,216,224,247,252,271,276,280,286,287,289,291]}]
	var $s = $('#signature').jSignature()
	
	$s.jSignature('setData', data, 'native')
	
	var newdata = $s.jSignature('getData', 'native')
	
	QUnit.deepEqual(
		data
		, newdata
	)
	
	$s.html("").unbind('change')
	
})

test("base30 - internal methods", function() {
	var undef, i, l
	/////
	// making sure arbitrary base (30 in this case) works for number.toString(base)
	/////
	var reference = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1a", "1b", "1c", "1d", "1e", "1f", "1g", "1h", "1i", "1j", "1k", "1l", "1m", "1n", "1o", "1p", "1q", "1r", "1s", "1t", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2a", "2b", "2c", "2d", "2e", "2f", "2g", "2h", "2i", "2j", "2k", "2l", "2m", "2n", "2o", "2p", "2q", "2r", "2s", "2t", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39"]
	, actual = [];
	for ( i = 0, l = 100; i < l; i++ ){ actual.push( i.toString(30)) };
	QUnit.deepEqual(
		actual
		, reference
	);

	// making sure debug exposes the internal methods
	// window.jSignatureDebug = {'modulename':{'methodname':methodpointer,...}, ...}
	QUnit.equal(
		( window.jSignatureDebug === undef ? false : true )
		, true
		, "Must have window.jSignatureDebug object with internal methods exposed through it."
	)
	
	/////
	// Testing core of conversion from base10 to base30
	/////

	/////
	// part 1

	
	var remapTailChars = window.jSignatureDebug['base30']['remapTailChars']
	// remap map for base30: 
	// 0123456789abcdefghijklmnopqrst
	// uvwxyzABCDEFGHIJKLMNOPQRSTUVWX
	
	// a = [10,20,30,40,50,77,98,103,234,345,456,567,789,1234,3456]
	// a.map(function(n){return n.toString(30)})
	var input  = ["a", "k", "10", "1a", "1k", "2h", "38", "3d", "7o", "bf", "f6", "ir", "q9", "1b4", "3p6"];
	reference = ["a", "k", "1u", "1E", "1O", "2L", "3C", "3H", "7S", "bJ", "fA", "iV", "qD", "1Fy", "3TA"];
	actual = []; 
	for ( i = 0, l = input.length; i < l; i++ ){ 
		actual.push( 
			remapTailChars(input[i])
		) 
	};
	QUnit.deepEqual(
		actual
		, reference
	);

	/////
	// part 2
	
	var data = [{"x":[172,170,167,164,161,149,144,136,131,104,94,86,71,65,62,55,54,52,49,48,48,48,51,54,63,66,78,82,89,97,103,107,126,129,130,135,139,147,149,152,155,156,159,159,159,159,157,156,156,154,153,151,150,149,148,147,147,147,151,154,162,165,177,183,197,204,209,231,238,271,284,293,315,323,330,340,343,343,339,336,324,317,283,271,263,243,236,214,210,204,199,197,195,196,208,213,231,239,245,264,273,309,326,338,370,382,419,428,441,456,464,475,476,475,468,461,432,418,406,384,378,359,355,351,349,349,350,370,378,417,436,488,501,515,542,553,569,589,626,630,633,634,629,601,591,580,553,542,505,494,485,470,464,459,446,445,447,451,471,479,506,516,545,558,564,579,583,586,591],"y":[280,279,277,275,272,262,258,250,244,203,188,177,155,147,138,123,118,110,95,91,80,77,66,63,56,54,50,50,49,48,48,48,53,56,58,66,73,89,93,99,109,116,137,141,151,155,167,170,174,183,187,199,203,207,213,217,230,233,241,246,251,252,256,257,259,259,259,255,251,235,226,220,200,193,186,167,160,140,132,128,116,112,103,101,101,104,107,119,124,130,140,149,167,172,197,205,221,225,228,234,235,236,236,235,226,221,200,191,180,164,155,127,121,117,105,100,85,81,80,80,81,100,109,122,142,158,168,211,222,254,263,278,279,279,279,276,272,263,224,217,209,183,165,126,117,109,93,87,79,79,79,83,88,93,119,134,172,183,216,224,247,252,271,276,280,286,287,289,291]}]
	var database30 = "5QZ2333c585ra8f637123100Y3393c47864j3154823313000Z210212111100Y4383c6e75m71xd9m87a30Z43c71yc8k7m46522Y1c5i86j91Ahc1wc1B9df8b1Z177tecm6j4420Y1k81Dj1Qderbgk1B431Z5sabrb1Bb9f65d1Y24k8ratd6f435_9EZ1223a4861Ffbm89f58f4b3b372401100Y53287g46a7l4a4c3494c4464d3855141200Z44g96k77j7k84c4920Y33c56a9i5p8g436110Z195l9bg9s64c5f410Y1j9dkga1Hb1w9f100Z3491D78qi1D98g6800Y455qf1Cb1x8n5j546122"
	
	var compressstrokeleg = window.jSignatureDebug['base30']['compressstrokeleg']
	
	var stroke = data[0]
	var strokebase30 = database30.split('_')
	
	QUnit.deepEqual(
		compressstrokeleg(stroke.x)
		, strokebase30[0]
	)	

	QUnit.deepEqual(
		compressstrokeleg(stroke.y)
		, strokebase30[1]
	)	

})

test("export tests - native to base30 roundtrip", function() {
	
	var data = [{"x":[172,170,167,164,161,149,144,136,131,104,94,86,71,65,62,55,54,52,49,48,48,48,51,54,63,66,78,82,89,97,103,107,126,129,130,135,139,147,149,152,155,156,159,159,159,159,157,156,156,154,153,151,150,149,148,147,147,147,151,154,162,165,177,183,197,204,209,231,238,271,284,293,315,323,330,340,343,343,339,336,324,317,283,271,263,243,236,214,210,204,199,197,195,196,208,213,231,239,245,264,273,309,326,338,370,382,419,428,441,456,464,475,476,475,468,461,432,418,406,384,378,359,355,351,349,349,350,370,378,417,436,488,501,515,542,553,569,589,626,630,633,634,629,601,591,580,553,542,505,494,485,470,464,459,446,445,447,451,471,479,506,516,545,558,564,579,583,586,591],"y":[280,279,277,275,272,262,258,250,244,203,188,177,155,147,138,123,118,110,95,91,80,77,66,63,56,54,50,50,49,48,48,48,53,56,58,66,73,89,93,99,109,116,137,141,151,155,167,170,174,183,187,199,203,207,213,217,230,233,241,246,251,252,256,257,259,259,259,255,251,235,226,220,200,193,186,167,160,140,132,128,116,112,103,101,101,104,107,119,124,130,140,149,167,172,197,205,221,225,228,234,235,236,236,235,226,221,200,191,180,164,155,127,121,117,105,100,85,81,80,80,81,100,109,122,142,158,168,211,222,254,263,278,279,279,279,276,272,263,224,217,209,183,165,126,117,109,93,87,79,79,79,83,88,93,119,134,172,183,216,224,247,252,271,276,280,286,287,289,291]}]
	var database30 = "data:image/jsignature;base30,5QZ2333c585ra8f637123100Y3393c47864j3154823313000Z210212111100Y4383c6e75m71xd9m87a30Z43c71yc8k7m46522Y1c5i86j91Ahc1wc1B9df8b1Z177tecm6j4420Y1k81Dj1Qderbgk1B431Z5sabrb1Bb9f65d1Y24k8ratd6f435_9EZ1223a4861Ffbm89f58f4b3b372401100Y53287g46a7l4a4c3494c4464d3855141200Z44g96k77j7k84c4920Y33c56a9i5p8g436110Z195l9bg9s64c5f410Y1j9dkga1Hb1w9f100Z3491D78qi1D98g6800Y455qf1Cb1x8n5j546122"
	
	var $s = $('#signature').jSignature()
	
	$s.jSignature('setData', data, 'native')
	
	var newdata = $s.jSignature('getData', 'base30')
	
	QUnit.deepEqual(
		'data:' + newdata.join(',')
		, database30
	)
	
	$s.jSignature('setData', database30)
	newdata = $s.jSignature('getData', 'native')

	QUnit.deepEqual(
		newdata
		, data
	)
	
	$s.html("").unbind('change')

})

}) // end of document.ready(