<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('newsletters', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->timestamp('send_date')->nullable();
            $table->boolean('enabled')->default(0);
            $table->string('subject');
            $table->text('content');
            $table->boolean('mailing_list')->default(0);
            $table->boolean('candidates')->default(0);
            $table->boolean('employers')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('newsletters');
    }
};
