<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Newsletter extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var \App\Newsletter
     */
    public $newsletter;

    public $hash;

    public $email;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(\App\Newsletter $newsletter,$hash,$email)
    {
        $this->newsletter = $newsletter;
        $this->hash = $hash;
        $this->email = $email;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $email = setting('general_newsletter_from_email');
        if(empty($email)){
            $email = setting('general_admin_email');
        }
        return $this->subject($this->newsletter->subject)->from($email,setting('general_site_name'))->view('mails.newsletter')->text('mails.newsletter-text');
    }
}
