<?php
namespace App\Lib;

use App\Email;
use App\MailingList;
use App\Newsletter;
use App\User;
use Carbon\Carbon;
use Illuminate\Mail\Mailer;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\View;

class CronJobs
{
    use HelperTrait;
    public function deleteTempFiles(){
        $path = 'storage/tmp';

        $objects = scandir($path);
        foreach ($objects as $object) {
             $dir = $path.'/'.$object;
            if(is_dir($dir) && $object !='..' && $object !='.'){
                if (filemtime($dir) < time() - 86400) {
                    deleteDir($dir);
                }
            }

        }
    }

    public function sendPendingEmails(){
        //send all emails that are pending
        $emails = Email::where('sent',0)->where('send_date','<=',\Illuminate\Support\Carbon::now()->toDateString())->limit(500)->get();

        foreach($emails as $email){
                $this->sendSavedEmail($email);
        }


    }

    /**
     * Sends a reminder to employers before an interview
     */
    public function sendInterviewReminder(){

    }

    public function sendInterviewFeedbackPrompt(){

    }

    public function sendNewsLetters(){
        set_time_limit(86400);
        $this->setConsoleDependencies();
        //get newsletter
        $newsletters = Newsletter::whereDate('send_date','<=',today())->where('sent',0)->where('enabled',1)->limit(10)->get();

        if(count($newsletters)==0){
            echo 'No newsletter to send';
            return;
        }

        foreach($newsletters as $newsletter){
            $newsletter->sent =1;
            $newsletter->save();

            $recipients = [];

            if($newsletter->mailing_list==1){
                foreach (MailingList::lazy() as $mailingList){
                    if(filter_var($mailingList->email, FILTER_VALIDATE_EMAIL) && subscribed($mailingList->email))
                    $recipients[$mailingList->email] = true;
                }
            }

            if($newsletter->candidates==1){
                foreach (User::where('role_id',3)->lazy() as $user){
                    if(filter_var($user->email, FILTER_VALIDATE_EMAIL) && subscribed($user->email))
                    $recipients[$user->email] = true;
                }
            }

            if($newsletter->employers==1){
                foreach (User::where('role_id',2)->lazy() as $user){
                    if(filter_var($user->email, FILTER_VALIDATE_EMAIL) && subscribed($user->email))
                    $recipients[$user->email] = true;
                }
            }

            foreach ($recipients as $recipient=>$value){
                 $hash = md5($recipient.env('APP_KEY'));
                 Mail::to($recipient)->send(new \App\Mail\Newsletter($newsletter,$hash,$recipient));
            }
            $total = count($recipients);
            echo "{$newsletter->subject} sent to {$total} recipients <br/>";
        }





    }

    private function setConsoleDependencies(){
        $file = './app/Lib/cphelpers.php';
        if(file_exists($file)){
            include_once './app/Lib/cphelpers.php';
        }
        $viewPath = resource_path('views');
        View::addLocation($viewPath);
        config()->set('view.paths',[$viewPath]);
    }


}
