<?php

namespace App\Http\Controllers\Site;

use App\Article;
use App\Http\Controllers\Controller;
use App\Lib\HelperTrait;
use App\MailingList;
use App\Unsubscribe;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    use HelperTrait;
    public function index(){

        //check if installation file exists and redirect to install if not
        if(!file_exists('../storage/installed')){
            return redirect('/install');
        }

        return tview('site.home.index');
    }

    public function article($slug){

        $article = Article::where('slug',$slug)->where('status',1)->first();
        if(!$article){
          return  abort(404);
        }


        return tview('site.home.article',compact('article'));
    }

    public function contact(){

        return tview('site.home.contact');
    }

    public function sendMail(Request $request){
        $this->validate($request,[
            'name'=>'required',
            'email'=>'required',
            'message'=>'required',
            'captcha' => 'required|captcha'
        ]);

        if(!empty(setting('general_admin_email')))
        {
            $this->sendEmail(setting('general_admin_email'),__('site.contact-form-message'),$request->message,['address'=>$request->email,'name'=>$request->name]);
        }

        return back()->with('flash_message',__('site.message-sent'));

    }

    public function joinList(Request $request){
        clearUnsubscribe($request->email);
        $this->validate($request,[
            'email'=>'required|email|unique:mailing_lists',
            'captcha' => 'required|captcha'
        ]);

        $requestData = $request->all();
        MailingList::create($requestData);

        return back()->with('flash_message', __('site.changes-saved'));

    }

    public function unsubscribe(Request $request,$hash){
        $email= $request->email;
        if(md5($email.env('APP_KEY')) != $hash){
            exit('Invalid link');
        }


        return view('site.home.unsubscribe',compact('email','hash'));
    }

    public function processUnsubscribe(Request $request){
        $this->validate($request,[
            'email'=>'required|email',
            'hash'=>'required'
        ]);

        $email = $request->email;
        $hash = $request->hash;
        if(md5($email.env('APP_KEY')) != $hash){
            exit('Invalid link');
        }



        if(!Unsubscribe::where('email',$email)->first()){
            Unsubscribe::create([
                'email'=>$email
            ]);
        }


        return view('site.home.unsubscribed',['email'=>$email]);
    }

}
