<?php

namespace App\Console;

use App\Lib\CronJobs;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->call(function () {
            $cronJobs = new CronJobs();
            $cronJobs->deleteTempFiles();
        })->daily();

        $schedule->call(function () {
            $cronJobs = new CronJobs();
            $cronJobs->sendPendingEmails();
        })->hourly();

        $schedule->call(function () {
            $cronJobs = new CronJobs();
            $cronJobs->sendNewsLetters();
        })->dailyAt(env('NEWSLETTER_HOUR','12:00')); //everyMinute();

    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
