<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $fillable = ['name','description','sort_order','public'];

    public function candidates()
    {
        return $this->belongsToMany(Candidate::class);
    }

    public function scopePublic($query){
        return $query->where('public',1);
    }


}
